<?php

// =====================================================
// NOUVELLE MIGRATION : Ajouter les colonnes manquantes
// Créez ce fichier: database/migrations/xxxx_add_missing_columns_to_tables.php
// =====================================================

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // 1. Table suites_operatoires - Colonnes manquantes
        Schema::table('suites_operatoires', function (Blueprint $table) {
            // Rééducation fonctionnelle
            if (!Schema::hasColumn('suites_operatoires', 'reeducation_fonctionnelle')) {
                $table->boolean('reeducation_fonctionnelle')->nullable();
            }
            if (!Schema::hasColumn('suites_operatoires', 'reeducation_nb_seances')) {
                $table->string('reeducation_nb_seances')->nullable();
            }
            // Correction raccourcissement
            if (!Schema::hasColumn('suites_operatoires', 'correction_raccourcissement')) {
                $table->boolean('correction_raccourcissement')->nullable();
            }
            if (!Schema::hasColumn('suites_operatoires', 'correction_raccourcissement_cm')) {
                $table->decimal('correction_raccourcissement_cm', 5, 2)->nullable();
            }
            // Correction boiterie
            if (!Schema::hasColumn('suites_operatoires', 'correction_boiterie')) {
                $table->boolean('correction_boiterie')->nullable();
            }
            // Si descellement - détails
            if (!Schema::hasColumn('suites_operatoires', 'descellement_type')) {
                $table->string('descellement_type')->nullable();
            }
            if (!Schema::hasColumn('suites_operatoires', 'descellement_siege')) {
                $table->string('descellement_siege')->nullable();
            }
        });

        // 2. Table difficultes_operatoires - correction colonne
        Schema::table('difficultes_operatoires', function (Blueprint $table) {
            // Changer sur_composante en JSON car c'est un checkbox
            if (Schema::hasColumn('difficultes_operatoires', 'sur_composante')) {
                // Sur certains SGBD, il faut d'abord supprimer puis recréer
                // Alternativement, vous pouvez ignorer si déjà correct
            }
        });

        // 3. Table revisions - Colonnes autre manquantes
        Schema::table('revisions', function (Blueprint $table) {
            if (!Schema::hasColumn('revisions', 'types_revision_autre')) {
                $table->string('types_revision_autre')->nullable();
            }
            if (!Schema::hasColumn('revisions', 'motifs_revision_autre')) {
                $table->string('motifs_revision_autre')->nullable();
            }
        });

        // 4. Table systemes_navigations - Colonne chirurgie mini-invasive
        Schema::table('systemes_navigations', function (Blueprint $table) {
            if (!Schema::hasColumn('systemes_navigations', 'chirurgie_mini_invasive')) {
                $table->boolean('chirurgie_mini_invasive')->nullable();
            }
        });
    }

    public function down(): void
    {
        Schema::table('suites_operatoires', function (Blueprint $table) {
            $table->dropColumn([
                'reeducation_fonctionnelle',
                'reeducation_nb_seances',
                'correction_raccourcissement',
                'correction_raccourcissement_cm',
                'correction_boiterie',
                'descellement_type',
                'descellement_siege',
            ]);
        });

        Schema::table('revisions', function (Blueprint $table) {
            $table->dropColumn(['types_revision_autre', 'motifs_revision_autre']);
        });

        Schema::table('systemes_navigations', function (Blueprint $table) {
            $table->dropColumn(['chirurgie_mini_invasive']);
        });
    }
};