<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Prophylaxie Antibiotique
        Schema::create('prophylaxies_antibiotiques', function (Blueprint $table) {
            $table->id();
            $table->foreignId('intervention_id')->unique()->constrained('interventions')->onDelete('cascade');
            $table->string('antibiotique')->nullable();
            $table->string('dose_par_jour')->nullable();
            $table->boolean('debute_per_operatoire')->nullable();
            $table->string('duree')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('prophylaxies_antibiotiques');
    }
};
