<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Analgésie
        Schema::create('analgesies', function (Blueprint $table) {
            $table->id();
            $table->foreignId('intervention_id')->unique()->constrained('interventions')->onDelete('cascade');
            $table->boolean('infiltration')->default(false);
            $table->boolean('catheter_en_place')->default(false);
            $table->string('produit')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('analgesies');
    }
};
