<?php

// database/migrations/xxxx_xx_xx_xxxxxx_create_details_therapeutiques_implants_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('details_therapeutiques_implants', function (Blueprint $table) {
            $table->id();
            $table->foreignId('intervention_id')->unique()->constrained('interventions')->onDelete('cascade');

            // Champs communs ou pour la Hanche
            $table->string('couple_frottement')->nullable();
            $table->string('type_cupule')->nullable();
            $table->string('tige_femoral_collerette')->nullable();
            $table->string('tige_femoral_fixation')->nullable();
            $table->boolean('resurfacage')->nullable();
            
            // Champs pour le Genou
            $table->string('type_arthroplastie')->nullable(); // Primaire, Révision
            $table->string('type_prothese_primaire')->nullable(); // Totale, unicompartimentale...
            $table->string('fixation_femoral')->nullable();
            $table->string('fixation_tibial')->nullable();
            $table->string('mobilite_insert')->nullable();
            $table->string('design_insert')->nullable();
            $table->boolean('patella_posee')->nullable();

            // Un champ JSON pour tout ce qui n'est pas critique pour les statistiques
            $table->jsonb('details_supplementaires')->nullable(); 

            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('details_therapeutiques_implants'); }
};