<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('suites_operatoires', function (Blueprint $table) {
            $table->id();
            $table->foreignId('intervention_id')->constrained('interventions')->onDelete('cascade');
            $table->integer('delai_mise_en_charge_jours')->nullable();
            $table->integer('delai_appui_total_mois')->nullable();
            $table->string('duree_sejour_hospitalier')->nullable();
            $table->jsonb('complications_per_operatoire')->nullable();
            $table->string('suites_immediates')->nullable(); // Simples ou Compliquées
            $table->jsonb('complications_immediates')->nullable();
            $table->jsonb('complications_secondaires')->nullable();
            $table->jsonb('complications_tardives')->nullable();
            $table->string('prise_en_charge_frais')->nullable();
            $table->string('prise_en_charge_frais_autre')->nullable();
            $table->string('dernier_recul_mois')->nullable();
            $table->string('eva_patient')->nullable();
            $table->string('pma_post_operatoire')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('suites_operatoires'); }
};