<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('implants', function (Blueprint $table) {
            $table->id();
            $table->foreignId('intervention_id')->constrained('interventions')->onDelete('cascade');
            $table->string('type_composant'); // Ex: "Cupule", "Tige Fémorale", "Insert"
            $table->string('societe')->nullable();
            $table->string('marque_modele')->nullable();
            $table->string('reference')->nullable();
            $table->string('numero_lot')->nullable();
            $table->string('udi_di_pi')->nullable();
            $table->date('date_fabrication')->nullable();
            $table->string('pays_fabrication')->nullable();
            $table->jsonb('details_specifiques')->nullable(); // Pour taille, alliage, fixation, etc.
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('implants'); }
};