<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('antecedents_terrains', function (Blueprint $table) {
            $table->id();
            $table->foreignId('intervention_id')->unique()->constrained('interventions')->onDelete('cascade');
            $table->jsonb('antecedents_medicaux')->nullable(); // Pour ["Drépanocytose", "Diabète", ...]
            $table->string('serologie_retroviral')->nullable();
            $table->boolean('traumatisme')->nullable();
            $table->boolean('corticotherapie')->nullable();
            $table->string('intervention_anterieure')->nullable();
            $table->string('intervention_anterieure_autre')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('antecedents_terrains'); }
};