<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('surgeons', function (Blueprint $table) {
            $table->id();
            // Cette colonne stockera l'UID de Firebase. Elle doit être unique.
            $table->string('firebase_uid')->unique();
            $table->string('nom')->nullable(); // Optionnel, pour un affichage facile
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('surgeons'); }
};