<?php

namespace App\Providers;

use App\Observers\ActivityLogObserver;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\File;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
        // Chemin vers votre dossier de modèles
        $modelsPath = app_path('Models');
        // Liste des modèles que vous souhaitez exclure (ex: le BaseModel lui-même)
        $excludedModels = ['BaseModel.php'];

        // On scanne tous les fichiers du dossier
        $modelFiles = File::files($modelsPath);

        foreach ($modelFiles as $file) {
            $filename = $file->getFilename();
            if (in_array($filename, $excludedModels)) {
                continue; // On ignore les modèles exclus
            }
            
            // On construit le nom complet de la classe du modèle
            $modelClass = 'App\\Models\\' . pathinfo($filename, PATHINFO_FILENAME);

            // On attache notre observer au modèle
            if (class_exists($modelClass)) {
                $modelClass::observe(ActivityLogObserver::class);
            }
        }
    }
}
