<?php

namespace App\Observers;

use Illuminate\Database\Eloquent\Model;

class ActivityLogObserver
{
    // Helper pour obtenir le nom du modèle en français (optionnel mais propre)
    private function getModelName(Model $model): string
    {
        // Ceci retourne le nom de la classe, ex: "Patient", "DonneesClinique"
        return class_basename($model);
    }

    public function created(Model $model): void
    {
        activity()
           ->performedOn($model)
           ->causedBy(auth()->user() ?? null) // Qui a fait l'action ?
           ->log("Création de " . $this->getModelName($model) . " #" . $model->id);
    }

    public function updated(Model $model): void
    {
        activity()
           ->performedOn($model)
           ->causedBy(auth()->user() ?? null)
           ->log("Mise à jour de " . $this->getModelName($model) . " #" . $model->id);
    }

    public function deleted(Model $model): void
    {
        activity()
           ->performedOn($model)
           ->causedBy(auth()->user() ?? null)
           ->log("Suppression de " . $this->getModelName($model) . " #" . $model->id);
    }
}