<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

abstract class BaseModel extends Model
{
    use LogsActivity;

    // Cette méthode configure les options de journalisation pour tous les modèles qui en héritent.
    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logAll() // Journalise tous les attributs ($fillable) du modèle.
            ->logOnlyDirty() // Ne journalise que les attributs qui ont changé lors d'une mise à jour.
            ->dontSubmitEmptyLogs(); // N'enregistre pas de log si rien n'a changé.
    }
}