<?php

namespace App\Http\Middleware;

use App\Models\Surgeon;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class IdentifySurgeon
{
    public function handle(Request $request, Closure $next): Response
    {
        // On récupère l'UID, que ce soit du corps de la requête ou d'un en-tête
        $firebaseUid = $request->input('surgeon_firebase_uid') ?? $request->header('X-Surgeon-Firebase-UID');

        if (!$firebaseUid) {
            // Si aucun UID n'est fourni, on rejette la requête.
            return response()->json(['message' => 'UID du chirurgien manquant.'], 401);
        }

        // On cherche le chirurgien. On utilise firstOrCreate pour le créer s'il n'existe pas.
        $surgeon = Surgeon::firstOrCreate(
            ['firebase_uid' => $firebaseUid],
            ['nom' => $request->input('surgeon_name', 'N/A')]
        );
        
        // Si pour une raison quelconque le chirurgien n'est pas trouvé/créé, on rejette.
        if (!$surgeon) {
            return response()->json(['message' => 'Chirurgien non autorisé.'], 403);
        }

        // --- C'EST LA PARTIE MAGIQUE ---
        // On stocke le chirurgien pour que l'Observer le trouve.
        config(['activitylog.causer' => $surgeon]);
        
        // On attache aussi le chirurgien à la requête elle-même.
        // Très utile pour ne pas avoir à le rechercher à nouveau dans le contrôleur !
        $request->attributes->add(['surgeon' => $surgeon]);

        // La requête est validée, on la laisse continuer vers le contrôleur.
        return $next($request);
    }
}