<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Difficulté Opératoire
        Schema::create('difficultes_operatoires', function (Blueprint $table) {
            $table->id();
            $table->foreignId('intervention_id')->unique()->constrained('interventions')->onDelete('cascade');
            $table->string('sur_composante')->nullable(); // acétabulaire, fémorale
            $table->jsonb('nature')->nullable(); // ["anesthésie", "saignement", ...]
            $table->string('nature_autre')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('difficultes_operatoires');
    }
};
