<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Système de Navigation
        Schema::create('systemes_navigations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('intervention_id')->unique()->constrained('interventions')->onDelete('cascade');
            $table->string('systeme_utilise')->nullable();
            $table->string('numero_serie')->nullable();
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('systemes_navigations');
    }
};
