<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Greffe Osseuse
        Schema::create('greffes_osseuses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('intervention_id')->unique()->constrained('interventions')->onDelete('cascade');
            $table->string('type')->nullable(); // Autologue, Allogreffe...
            $table->string('localisation')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('greffes_osseuses');
    }
};
