<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('donnees_anesthesiques', function (Blueprint $table) {
            $table->id();
            $table->foreignId('intervention_id')->constrained('interventions')->onDelete('cascade');
            $table->string('type_anesthesie')->nullable();
            $table->string('type_anesthesie_autre')->nullable();
            $table->string('classification_asa')->nullable();
            $table->boolean('complications_per_anesthesiques')->nullable();
            $table->text('complications_per_anesthesiques_details')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('donnees_anesthesiques'); }
};