<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('revisions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('intervention_id')->constrained('interventions')->onDelete('cascade');
            $table->boolean('est_une_revision')->default(false);
            $table->jsonb('types_revision')->nullable();
            $table->string('types_revision_autre')->nullable();
            $table->jsonb('motifs_revision')->nullable();
            $table->string('motifs_revision_autre')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('revisions'); }
};