<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('imageries_diagnostics', function (Blueprint $table) {
            $table->id();
            $table->foreignId('intervention_id')->constrained('interventions')->onDelete('cascade');
            $table->jsonb('techniques')->nullable(); // Pour ["Radiographie standard", "Scanner", ...]
            $table->string('resultat_principal')->nullable();
            $table->string('resultat_principal_autre')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('imageries_diagnostics'); }
};