<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('donnees_biologiques', function (Blueprint $table) {
            $table->id();
            $table->foreignId('intervention_id')->constrained('interventions')->onDelete('cascade');
            $table->decimal('globules_blancs', 10, 3)->nullable();
            $table->decimal('neutrophiles', 10, 3)->nullable();
            $table->decimal('hemoglobine', 5, 2)->nullable();
            $table->integer('plaquettes')->nullable();
            $table->string('groupe_sanguin')->nullable();
            $table->string('rhesus')->nullable();
            $table->decimal('creatinine', 8, 2)->nullable();
            $table->decimal('glycemie', 8, 2)->nullable();
            $table->decimal('crp', 8, 2)->nullable();
            $table->string('electrophorese_hemoglobine')->nullable();
            $table->string('procalcitonine')->nullable();
            $table->string('tp_tck')->nullable();
            $table->string('inr')->nullable();
            $table->text('autre_biologie')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('donnees_biologiques'); }
};