<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('donnees_cliniques', function (Blueprint $table) {
            $table->id();
            $table->foreignId('intervention_id')->unique()->constrained('interventions')->onDelete('cascade');
            $table->decimal('poids_kg', 6, 2)->nullable();
            $table->decimal('taille_cm', 6, 2)->nullable();
            $table->decimal('imc', 5, 2)->nullable();
            $table->string('cote_opere');
            $table->boolean('boiterie')->nullable();
            $table->boolean('impotence_fonctionnelle')->nullable();
            $table->string('impotence_fonctionnelle_precision')->nullable(); // absolue ou relative
            $table->string('pma_pre_operatoire')->nullable();
            $table->string('score_parker')->nullable();
            $table->boolean('ilmi')->nullable();
            $table->decimal('ilmi_cm', 5, 2)->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('donnees_cliniques'); }
};