<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('interventions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('patient_id')->constrained('patients')->onDelete('cascade');
            $table->enum('type_prothese', ['hanche', 'genou']);
            $table->string('hopital_etablissement')->nullable();
            $table->string('numero_identifiant_patient')->unique()->nullable();
            $table->date('date_intervention')->nullable();
            $table->time('heure_debut')->nullable();
            $table->time('heure_fin')->nullable();
            $table->foreignId('surgeon_id')->nullable()->constrained('surgeons')->onDelete('cascade');
            // Ce champ jsonb stockera toutes les données qui n'ont pas leur propre table/colonne dédiée.
            // AJOUTÉ : La colonne qui causait l'erreur
            $table->string('chirurgien_identifiant')->nullable();
            $table->jsonb('donnees_formulaire_autres')->nullable();
            //
            // Données thérapeutiques chirurgicales
            $table->string('voie_dabord')->nullable();
            $table->string('voie_dabord_autre')->nullable();
            //
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('interventions'); }
};