<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('patients', function (Blueprint $table) {
            $table->id();
            $table->string('nom');
            $table->string('prenom')->nullable();
            $table->date('date_naissance')->nullable();
            $table->string('sexe')->nullable();
            $table->string('profession')->nullable();
            $table->string('profession_autre')->nullable();
            $table->text('adresse')->nullable();
            $table->string('telephone')->nullable();
            
            // AJOUTÉ : La colonne pour l'identifiant unique du patient.
            // C'est ici que la contrainte d'unicité doit être.
            $table->string('numero_identifiant')->unique()->nullable();
            
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('patients'); }
};