<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SuitesOperatoire extends Model
{
    use HasFactory;
    protected $guarded = [];

    protected $casts = [
        'complications_per_operatoire' => 'array',
        'complications_immediates' => 'array',
        'complications_secondaires' => 'array',
        'complications_tardives' => 'array',
    ];

    public function intervention()
    {
        return $this->belongsTo(Intervention::class);
    }
}
