<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Patient extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    // C'est une bonne pratique de lister les champs que vous autorisez à être remplis massivement.
    protected $fillable = [
        'nom',
        'prenom',
        'date_naissance',
        'sexe',
        'profession',
        'profession_autre',
        'adresse',
        'telephone',
        'numero_identifiant', // AJOUTÉ : Pour autoriser son remplissage via updateOrCreate
    ];

    /**
     * Les attributs qui doivent être convertis en types natifs.
     *
     * @var array
     */
    protected $casts = [
        'date_naissance' => 'date',
    ];

    /**
     * Définit la relation "un-à-plusieurs" : Un patient a plusieurs interventions.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function interventions(): HasMany
    {
        // Cette ligne dit à Laravel : "Un Patient est lié à plusieurs modèles Intervention".
        // Laravel supposera par convention que la table 'interventions' a une colonne 'patient_id'.
        return $this->hasMany(Intervention::class);
    }
}
