<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Intervention extends Model
{
    use HasFactory;
    // Permet l'assignation de masse. Pour la production, préférez $fillable.
    protected $guarded = [];

    // Indique à Laravel de convertir automatiquement ces colonnes.
    protected $casts = [
        'donnees_formulaire_autres' => 'array',
        'date_intervention' => 'date',
    ];

    public function patient(): BelongsTo
    {
        return $this->belongsTo(Patient::class);
    }

    public function surgeon(): BelongsTo
    {
        return $this->belongsTo(Surgeon::class);
    }
    
    public function antecedentsTerrains(): HasOne
    {
        return $this->hasOne(AntecedentsTerrain::class);
    }

    public function donneesCliniques(): HasOne
    {
        return $this->hasOne(DonneesClinique::class);
    }

    public function donneesBiologiques(): HasOne
    {
        return $this->hasOne(DonneesBiologique::class);
    }

    public function imageriesDiagnostics(): HasOne
    {
        return $this->hasOne(ImageriesDiagnostic::class);
    }
    
    public function suitesOperatoires(): HasOne
    {
        return $this->hasOne(SuitesOperatoire::class);
    }

    public function revision(): HasOne
    {
        return $this->hasOne(Revision::class);
    }

    public function donneesAnesthesiques(): HasOne
    {
        return $this->hasOne(DonneesAnesthesique::class);
    }

    public function implants(): HasMany
    {
        return $this->hasMany(Implant::class);
    }

    public function detailsTherapeutiquesImplants(): HasOne
    {
        return $this->hasOne(DetailsTherapeutiquesImplants::class); 
    }

    public function greffeOsseuse(): HasOne
    {
        return $this->hasOne(GreffesOsseuses::class);
    }

    public function systemeNavigation(): HasOne
    {
        return $this->hasOne(SystemesNavigation::class);
    }
    
    public function analgesie(): HasOne
    {
        return $this->hasOne(Analgesies::class);
    }
    
    public function prophylaxieAntibiotique(): HasOne
    {
        return $this->hasOne(ProphylaxiesAntibiotiques::class);
    }

    public function difficulteOperatoire(): HasOne
    {
        return $this->hasOne(DifficultesOperatoires::class);
    }
}