<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ImageriesDiagnostic extends Model
{
    use HasFactory;

    // Autoriser le remplissage de tous les champs
    protected $guarded = [];

    /**
     * Les attributs qui doivent être "castés" vers des types natifs.
     */
    protected $casts = [
        // CETTE LIGNE EST LA SOLUTION
        // Elle dit à Eloquent de transformer automatiquement le tableau reçu
        // pour la clé 'techniques' en une chaîne JSON avant de l'enregistrer.
        'techniques' => 'array',
    ];

    /**
     * Définit la relation inverse.
     */
    public function intervention(): BelongsTo
    {
        return $this->belongsTo(Intervention::class);
    }
}
