<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AntecedentsTerrain extends Model
{
    use HasFactory;

    /**
     * Le nom de la table associée au modèle.
     * (Optionnel si le nom de la table est le pluriel du nom du modèle)
     * @var string
     */
    protected $table = 'antecedents_terrains';

    /**
     * Les attributs qui ne sont pas massivement assignables.
     * Utiliser un tableau vide est une façon simple de tout autoriser.
     * @var array
     */
    protected $guarded = [];

    /**
     * Les attributs qui doivent être "castés" vers des types natifs.
     * C'est ici que la magie opère.
     *
     * @var array
     */
    protected $casts = [
        // CETTE LIGNE DIT À LARAVEL :
        // "Quand je sauvegarde 'antecedents_medicaux', transforme le tableau en JSON.
        // Quand je le lis, transforme le JSON en tableau."
        'antecedents_medicaux' => 'array',
        
        // C'est aussi une bonne pratique de caster les booléens
        'traumatisme' => 'boolean',
        'corticotherapie' => 'boolean',
    ];

    /**
     * Définit la relation inverse : Cet enregistrement appartient à une Intervention.
     */
    public function intervention(): BelongsTo
    {
        return $this->belongsTo(Intervention::class);
    }
}
